# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#   * Rearrange models' order
#   * Make sure each model has one field with primary_key=True
#   * Remove `managed = False` lines if you wish to allow Django to create, modify, and delete the table
# Feel free to rename the models, but don't rename db_table values or field names.
#
# Also note: You'll have to insert the output of 'django-admin sqlcustom [app_label]'
# into your database.
from __future__ import unicode_literals

from django.db import models
from django.core.exceptions import ObjectDoesNotExist
from django.contrib.auth.models import User
from django.contrib import admin
from datetime import datetime, date, timedelta
import calendar
import os
#from PIL import Image
from roocdx.thumbs import ImageWithThumbsField

def get_upload_path_to_test(instance, filename):

    valor= 'exams/'+ str(instance.exam_in.exam_id)+'/'+ str(instance.id)+filename

    return valor

def get_upload_path_to_test2(instance, filename):

    valor= 'exams/'+ str(instance.exam_in.exam_id)+'/'+ str(instance.id)+filename

    return valor
def get_upload_path_Docs(instance, filename):

    valor= 'entries/'+ str(instance.entry_id)+'/'+filename

    return valor
def get_upload_path_Inv(instance, filename):

    valor= 'clients/'+ str(instance.created_for.client_id)+'/'+ str(instance.for_month)+'/'+filename

    return valor

# Choices options
SEX_CHOICES = (('M','Male'), ('F','Female'),)
TDC_CHOICES= (('AMEX','AMEX'), ('VISA','VISA'),('MASTER CARD','MASTER CARD'),)

Suffix_CHOICES=(('0','Dr.'),('1','M.D.'),('2','CT-(ASCP)'))


class AuthGroup(models.Model):
    name = models.CharField(unique=True, max_length=80)

    class Meta:
        managed = False
        db_table = 'auth_group'


class AuthGroupPermissions(models.Model):
    group_id = models.IntegerField()
    permission_id = models.IntegerField()

    class Meta:
        managed = False
        db_table = 'auth_group_permissions'
        unique_together = (('group_id', 'permission_id'),)


class AuthPermission(models.Model):
    name = models.CharField(max_length=255)
    content_type_id = models.IntegerField()
    codename = models.CharField(max_length=100)

    class Meta:
        managed = False
        db_table = 'auth_permission'
        unique_together = (('content_type_id', 'codename'),)


class AuthUser(models.Model):
    password = models.CharField(max_length=128)
    last_login = models.DateTimeField(blank=True, null=True)
    is_superuser = models.IntegerField()
    username = models.CharField(unique=True, max_length=30)
    first_name = models.CharField(max_length=30)
    last_name = models.CharField(max_length=30)
    email = models.CharField(max_length=254)
    is_staff = models.IntegerField()
    is_active = models.IntegerField()
    date_joined = models.DateTimeField()

    class Meta:
        managed = False
        db_table = 'auth_user'

    def get_group_name(self):
        name=''
        if self.is_active:
            group1=AuthUserGroups.objects.get(user_id=self.id)
            group=AuthGroup.objects.get(id=group1.group_id)

            return group.name
        else:
            return name

    def get_group_id(self):
        name=0
        if self.is_active:
            group1=AuthUserGroups.objects.get(user_id=self.id)
            return group1.group_id
        else:
            return name


class AuthUserGroups(models.Model):
    user_id = models.IntegerField()
    group_id = models.IntegerField()

    class Meta:
        managed = False
        db_table = 'auth_user_groups'
        unique_together = (('user_id', 'group_id'),)


class AuthUserUserPermissions(models.Model):
    user_id = models.IntegerField()
    permission_id = models.IntegerField()

    class Meta:
        managed = False
        db_table = 'auth_user_user_permissions'
        unique_together = (('user_id', 'permission_id'),)


##########################################################################################################################################################
#Class to manipulate all Patient
##########################################################################################################################################################

class UserProfile(models.Model):
    id= models.AutoField(primary_key=True)
    user = models.OneToOneField(User,on_delete=models.SET_NULL, related_name='profile', null=True, blank=True)
    phone= models.CharField(max_length=20, blank=True, default='', null=True)
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    address = models.CharField(max_length=150, blank=True, default='',null=True)
    address2 = models.CharField(max_length=150, blank=True, default='',null=True)
    city = models.CharField(max_length=50, blank=True, default='',null=True)
    state = models.CharField(max_length=50, blank=True, default='',null=True)
    zipcode= models.CharField(max_length=20, blank=True, default='', null=True)
    lab_id=models.IntegerField(default=1)

    class Meta:
        verbose_name_plural = 'UserProfiles'

    def get_group_name(self):

        group1=AuthUserGroups.objects.get(user_id=self.user.id)
        group=AuthGroup.objects.get(id=group1.group_id)

        return group.name


    def get_group_id(self):

        group1=AuthUserGroups.objects.get(user_id=self.user.id)

        return group1.group_id


##########################################################################################################################################################
#Class to manipulate Lab
##########################################################################################################################################################

class Lab(models.Model):
    lab_id= models.AutoField(primary_key=True)
    lab_name = models.CharField(max_length=150, blank=True, default='',null=True)
    lab_clia_id=models.CharField(max_length=20, blank=True, default='', null=True)
    lab_address = models.CharField(max_length=150, blank=True, default='',null=True)
    lab_address2 = models.CharField(max_length=150, blank=True, default='',null=True)
    lab_city = models.CharField(max_length=50, blank=True, default='',null=True)
    lab_state = models.CharField(max_length=50, blank=True, default='',null=True)
    lab_zipcode= models.CharField(max_length=20, blank=True, default='', null=True)
    lab_phone=models.CharField(max_length=20, blank=True, default='', null=True)
    lab_fax= models.CharField(max_length=20, blank=True, default='', null=True)
    lab_email = models.CharField(max_length=254)
    lab_website=models.CharField(max_length=254)

    class Meta:
        verbose_name_plural = 'Labs'

    def how_many_client_are_pending(self):

        total=0
        recs = Client.objects.filter(is_aproved=0)
        total= recs.count()

        return total

    def active_clients(self):

        total=0
        recs = Client.objects.filter(is_aproved=1)
        total= recs.count()

        return total

    def how_many_entries_are_pending(self):

        total=0
        recs = Entry.objects.filter(initial_info=1)
        total= recs.count()

        return total

    def how_many_entries_are_completed(self):

        total=0
        start_date= date.today()
        end_date = start_date
        date_with_time = datetime(year=start_date.year, month=start_date.month, day=start_date.day)
        start_date = date_with_time.replace(hour=00, minute=00)
        date_with_time2 = datetime(year=end_date.year, month=end_date.month, day=end_date.day)
        end_date = date_with_time2.replace(hour=23, minute=59)
        #recs = models.Entry.objects.filter(final_info=1)
        Entries=Entry.objects.filter(initial_info=1,created_date__range=(start_date,end_date))
        total=Entries.count()

        if Entries:
            for Ent in Entries:
                if Ent.accession_number.all():
                    for acc in Ent.accession_number.all():
                        if (acc.SP_completed == 1) or (acc.MP_completed == 1) or (acc.Non_gyn_completed == 1) or (acc.GYN_completed == 1):
                            total=total + 1

        return total

    def qc_total_entries_today(self):

        total=0
        start_date= date.today()
        end_date = start_date
        date_with_time = datetime(year=start_date.year, month=start_date.month, day=start_date.day)
        start_date = date_with_time.replace(hour=00, minute=00)
        date_with_time2 = datetime(year=end_date.year, month=end_date.month, day=end_date.day)
        end_date = date_with_time2.replace(hour=23, minute=59)

        Entries=Entry.objects.filter(initial_info=1,created_date__range=(start_date,end_date))
        if Entries:
            for Ent in Entries:
                if Ent.accession_number.all():
                    for acc in Ent.accession_number.all():
                        if acc.quality_control and not acc.quality_control_aproved:
                            total=total + 1

        return total

    def qc_total_entries(self):

        total=0

        Entries=Entry.objects.filter(initial_info=1)
        if Entries:
            for Ent in Entries:
                if Ent.accession_number.all():
                    for acc in Ent.accession_number.all():
                        if acc.quality_control and not acc.quality_control_aproved:
                            total=total + 1

        return total

    def total_entries_today(self):

        total=0
        start_date= date.today()
        end_date = start_date
        date_with_time = datetime(year=start_date.year, month=start_date.month, day=start_date.day)
        start_date = date_with_time.replace(hour=00, minute=00)
        date_with_time2 = datetime(year=end_date.year, month=end_date.month, day=end_date.day)
        end_date = date_with_time2.replace(hour=23, minute=59)

        Entries=Entry.objects.filter(initial_info=1,created_date__range=(start_date,end_date))
        total=Entries.count()

        return total

##########################################################################################################################################################
#Class to manipulate all Clients
##########################################################################################################################################################

class Client(models.Model):
    client_id= models.AutoField(primary_key=True)
    client_user = models.OneToOneField(User,on_delete=models.SET_NULL, related_name='client', null=True, blank=True)
    client_code= models.CharField(max_length=20,unique=True,default='', null=True)
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    first_name = models.CharField(max_length=150, blank=True, default='',null=True)
    last_name = models.CharField(max_length=150, blank=True, default='',null=True)
    business_UPIN_number= models.CharField(max_length=30, blank=True, default='', null=True)
    business_legal_name = models.CharField(max_length=150, blank=True, default='',null=True)
    business_phone= models.CharField(max_length=20, blank=True, default='', null=True)
    contact_phone=models.CharField(max_length=20, blank=True, default='', null=True)
    business_ext= models.CharField(max_length=10, blank=True, default='', null=True)
    business_fax= models.CharField(max_length=20, blank=True, default='', null=True)
    business_email = models.CharField(max_length=254,default='', null=True)
    business_address = models.CharField(max_length=150, blank=True, default='',null=True)
    business_address2 = models.CharField(max_length=150, blank=True, default='',null=True)
    business_city = models.CharField(max_length=50, blank=True, default='',null=True)
    business_state = models.CharField(max_length=50, blank=True, default='',null=True)
    business_zipcode= models.CharField(max_length=20, blank=True, default='', null=True)
    representative_SSN_number= models.CharField(max_length=10, blank=True, default='', null=True)
    is_aproved= models.BooleanField(default=0)
    notification= models.BooleanField(default=0)
    e_fax=models.BooleanField(default=0)
    website=models.BooleanField(default=0)
    printed=models.BooleanField(default=0)
    interface=models.BooleanField(default=0)
    lab_id=models.BooleanField(default=1)
    attending_physician_name=models.CharField(max_length=150, blank=True, default='',null=True)


    class Meta:
        verbose_name_plural = 'Clients'

    def has_price(self):

        prices= ClienExamPrice.objects.filter(created_for_client=self)
        if prices.count() > 0:
            return True
        else:
            return False

    def get_full_name(self):

        full_name=self.first_name + ' '+ self.last_name

        return full_name

    def get_invoices(self):

        Invs=ClientInvoices.objects.filter(created_for=self)

        return Invs

##########################################################################################################################################################
#Class to manipulate all Patient
##########################################################################################################################################################

class Patient(models.Model):
    patient_id= models.AutoField(primary_key=True)
    ext_id=models.CharField(max_length=20, blank=True, default='', null=True)
    patient_user = models.OneToOneField(User,on_delete=models.SET_NULL, related_name='patient_user', default='', null=True, blank=True)
    patient_client=models.ForeignKey(Client, to_field='client_id', default='', null=True, blank=True)
    dob = models.DateField(blank=True, null=True, default=None)
    age=models.IntegerField(blank=True, null=True)
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    first_name = models.CharField(max_length=150, blank=True, default='',null=True)
    last_name = models.CharField(max_length=150, blank=True, default='',null=True)
    phone=models.CharField(max_length=20, blank=True, default='', null=True)
    address = models.CharField(max_length=150, blank=True, default='',null=True)
    address2 = models.CharField(max_length=150, blank=True, default='',null=True)
    city = models.CharField(max_length=50, blank=True, default='',null=True)
    state = models.CharField(max_length=50, blank=True, default='',null=True)
    zipcode= models.CharField(max_length=20, blank=True, default='', null=True)
    SSN_number= models.CharField(max_length=10, blank=True, default='', null=True)
    gender=models.CharField(max_length=1, default='', choices=SEX_CHOICES, null=True)
    lab_id=models.BooleanField(default=1)
    notification= models.BooleanField(default=0)
    ethnicity=models.CharField(max_length=150, blank=True, default='',null=True)
    insurance_type= models.BooleanField(default=0)  #0 is billing to the client
    insurance_name = models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_dob = models.DateField(blank=True, null=True, default=None)
    insurance_suscriber_number=models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_group=models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_ICD10=models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_UPIN=models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_responsible_party=models.CharField(max_length=120, blank=True, default='',null=True)
    insurance_relationship=models.CharField(max_length=120, blank=True, default='',null=True)

    class Meta:
        verbose_name_plural = 'Patients'

    def full_name(self):
        full_name=self.first_name + ' '+ self.last_name

        return full_name

    def show_SSN(self):

        if self.SSN_number != None:
            ssn = '***-**-' + self.SSN_number[-4:]
        else:
            ssn= self.SSN_number
        return ssn

    def how_old(self):
        if self.dob:
            today = date.today()
            dob= self.dob
            self.age=today.year - dob.year - ((today.month, today.day) < (dob.month, dob.day))
            return self.age

    def show_gender_name(self):
        if self.gender == 'M':
            name='Male'
        else:
            name='Female'

        return name


class DjangoAdminLog(models.Model):
    action_time = models.DateTimeField()
    object_id = models.TextField(blank=True, null=True)
    object_repr = models.CharField(max_length=200)
    action_flag = models.SmallIntegerField()
    change_message = models.TextField()
    content_type_id = models.IntegerField(blank=True, null=True)
    user_id = models.IntegerField()

    class Meta:
        managed = False
        db_table = 'django_admin_log'


class DjangoContentType(models.Model):
    app_label = models.CharField(max_length=100)
    model = models.CharField(max_length=100)

    class Meta:
        managed = False
        db_table = 'django_content_type'
        unique_together = (('app_label', 'model'),)


class DjangoMigrations(models.Model):
    app = models.CharField(max_length=255)
    name = models.CharField(max_length=255, default='')
    applied = models.DateTimeField()

    class Meta:
        managed = False
        db_table = 'django_migrations'


class DjangoSession(models.Model):
    session_key = models.CharField(primary_key=True, max_length=40)
    session_data = models.TextField()
    expire_date = models.DateTimeField()

    class Meta:
        managed = False
        db_table = 'django_session'


##########################################################################################################################################################
#Class to manipulate all USA States
##########################################################################################################################################################

class state(models.Model):
    id = models.AutoField(primary_key=True)
    code = models.CharField(max_length=2)
    name = models.CharField(max_length=64)

    class Meta:
        verbose_name_plural = 'States'


##########################################################################################################################################################
#Class to manipulate all Result Category
##########################################################################################################################################################
class ResultCategory(models.Model):
    cat_id=models.AutoField(primary_key=True)
    cat_name=models.CharField(max_length=40, blank=True, default='',null=True)
    short_name=models.CharField(max_length=40, blank=True, default='',null=True)

    class Meta:
        verbose_name_plural = 'ResultCategories'


##########################################################################################################################################################
#Class to manipulate all Result SubCategory
##########################################################################################################################################################
class ResultSubCategory(models.Model):
    subcat_id=models.AutoField(primary_key=True)
    subcat_name=models.CharField(max_length=40, blank=True, default='',null=True)

    class Meta:
        verbose_name_plural = 'ResultSubCategories'

##########################################################################################################################################################
#Class to manipulate all Case type to refer all king of services lap provided
##########################################################################################################################################################

class CaseType(models.Model):
    case_type_id=models.AutoField(primary_key=True)
    case_type_name=models.CharField(max_length=40, blank=True, default='', null=True)

    class Meta:
        verbose_name_plural = 'CaseTypes'

##########################################################################################################################################################
#Class to manipulate all Result Codes
##########################################################################################################################################################
class Result_code(models.Model):
    code_id= models.AutoField(primary_key=True)
    code_name = models.CharField(max_length=20, blank=True, unique=True, default='',null=True)
    code_description= models.CharField(max_length=120, blank=True, default='', null=True)
    code_result_area=models.ForeignKey(ResultCategory, to_field="cat_id")
    code_result_subcat=models.ForeignKey(ResultSubCategory, to_field="subcat_id", default='')
    code_casetype_result= models.ForeignKey(CaseType, to_field="case_type_id")
    code_result_type=models.BooleanField(default=0)
    lab_id=models.BooleanField(default=1)

    class Meta:
        verbose_name_plural = 'Result_codes'

    def show_result_type(self):

        if self.code_result_type:
            type='Positive'
        else:
            type='Negative'


        return type


##########################################################################################################################################################
#Class to manipulate all Exams
##########################################################################################################################################################
class Exam(models.Model):
    exam_id= models.AutoField(primary_key=True)
    exam_name = models.CharField(max_length=20, blank=True, default='',null=True)
    test_code = models.CharField(max_length=20, blank=True, default='',null=True)
    cpt_name = models.CharField(max_length=20, blank=True, default='',null=True)
    exam_description= models.CharField(max_length=400, blank=True, default='', null=True)
    exam_default_price=models.DecimalField(max_digits=10, decimal_places=2, default=0)
    exam_casetype= models.ForeignKey(CaseType, to_field="case_type_id" )
    how_many_cut= models.IntegerField(default=0, null=True)
    lab_id=models.BooleanField(default=1)


    class Meta:
        verbose_name_plural = 'Exams'

    def get_cut_range(self):
        aux=''
        if self.how_many_cut > 0:
            aux=range(0,self.how_many_cut)

        return aux

    def defined_price(self,client_id):
        """
        #### Return the price if was previusly defined in ClientExamPrice model if not return default price for this Client.
        """
        price=1
        if self.clienexamprice_set.all():
            for price in self.clienexamprice_set.all():

                if price.created_for_client.client_id == int(client_id):
                    price= price.price
                else:
                    price=self.exam_default_price

        return price



##########################################################################################################################################################
#Class to manipulate all Client-Exam-Price
##########################################################################################################################################################
class ClienExamPrice(models.Model):
    id= models.AutoField(primary_key=True)
    client_exam_id= models.ForeignKey(Exam, to_field="exam_id", default='')
    created_for_client= models.ForeignKey(Client,  to_field="client_id", default='')
    price= models.DecimalField(max_digits=10, decimal_places=2, default=0)

    class Meta:
        verbose_name_plural = 'ClienExamPrices'
#########################################################################################################################################################
#Class to manipulate all Accession
##########################################################################################################################################################
class Accession(models.Model):
    id= models.AutoField(primary_key=True)
    accession_number=models.CharField(max_length=20, blank=True, default='',null=True)
    exam_in=models.ForeignKey(Exam, to_field='exam_id', default='')
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    barcode=models.CharField(max_length=20, blank=True, default='',null=True)
    barcode_img= models.ImageField(upload_to=get_upload_path_to_test, blank=True, null=True)
    result_in_speciment= models.ManyToManyField(Result_code, related_name='speciment', blank=True, default='')
    result_in_additional= models.ManyToManyField(Result_code, related_name='additional', blank=True, default='')
    result_in_interpretation= models.ManyToManyField(Result_code, related_name='interpretation', blank=True, default='')
    result_in_hormonal= models.ManyToManyField(Result_code, related_name='hormonal', blank=True, default='')
    result_in_molecular_CHlamydia_trachomatis= models.ManyToManyField(Result_code, related_name='chlamydia', blank=True, default='')
    result_in_molecular_Neiseria_gonorroeae= models.ManyToManyField(Result_code, related_name='gonorroea', blank=True, default='')
    GYN_result_comment= models.TextField(max_length=400, default='', blank=True, null=True)
    GYN_result_caption=models.CharField(max_length=120, blank=True, default='',null=True)
    GYN_result_photo=models.ImageField(upload_to=get_upload_path_to_test2, blank=True, null=True)
    Non_GYN_result_speciment_received=models.CharField(max_length=150, blank=True, default='',null=True)
    Non_GYN_result_clinical_data=models.CharField(max_length=150, blank=True, default='',null=True)
    Non_GYN_result_gross_description= models.TextField(max_length=400, default='', blank=True, null=True)
    Non_GYN_result_diagnosis=models.CharField(max_length=150, blank=True, default='',null=True)
    Non_GYN_result_comment= models.TextField(max_length=400, default='', blank=True, null=True)
    Non_GYN_result_photo=models.ImageField(upload_to=get_upload_path_to_test2, blank=True, null=True)
    Non_GYN_result_caption=models.CharField(max_length=120, blank=True, default='',null=True)
    MP_result_comment= models.TextField(max_length=400, default='', blank=True, null=True)
    MP_result_photo=models.ImageField(upload_to=get_upload_path_to_test2, blank=True, null=True)
    MP_result_caption=models.CharField(max_length=120, blank=True, default='',null=True)
    SP_completed=models.BooleanField(default=0)
    MP_completed=models.BooleanField(default=0)
    Non_gyn_completed=models.BooleanField(default=0)
    GYN_completed=models.BooleanField(default=0)
    completed_date=models.DateField(blank=True, null=True,db_index=True)
    SP_result_part_1=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_2=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_3=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_4=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_5=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_6=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_7=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_8=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_9=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_10=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_11=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_part_12=models.CharField(max_length=150, blank=True, default='',null=True)
    SP_result_comment= models.TextField(max_length=400, default='', blank=True, null=True)
    SP_result_photo=models.ImageField(upload_to=get_upload_path_to_test2, blank=True, null=True)
    SP_result_caption=models.CharField(max_length=120, blank=True, default='',null=True)
    finalized_date=models.DateTimeField(blank=True, null=True)
    price=models.DecimalField(max_digits=10, decimal_places=2, default=0)
    pathology_queve=models.BooleanField(default=0)
    pathology_aproved=models.BooleanField(default=0)
    pathology_comment= models.TextField(max_length=400, default='', blank=True, null=True)
    quality_control=models.BooleanField(default=0)
    quality_control_aproved=models.BooleanField(default=0)





##########################################################################################################################################################
#Class to manipulate all Entry
##########################################################################################################################################################
class Entry(models.Model):
    entry_id= models.AutoField(primary_key=True)
    collection_date= models.DateField(blank=True, null=True,db_index=True)
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    patient= models.ForeignKey(Patient, to_field='patient_id', unique_for_date='collection_date')
    physician_name = models.CharField(max_length=120, blank=True, default='',null=True)
    step= models.IntegerField(default=0, null=True)
    test_in_entry = models.ManyToManyField(Exam, related_name='entry', blank=True, default='')
    accession_number= models.ManyToManyField(Accession, related_name='access',  blank=True, default='')
    notes= models.TextField(default='', blank=True, null=True)
    initial_info= models.IntegerField(default=0, null=True)  #0 when not completed 1 when is fullfill completed
    GYN_Cervix=models.BooleanField(default=0)
    GYN_Vaginal=models.BooleanField(default=0)
    GYN_Endocervix=models.BooleanField(default=0)
    GYN_None=models.BooleanField(default=0)
    GYN_mestrual= models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_last_menstrual_period = models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_previous_biopsy= models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_pap_smear= models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_abnormal_report= models.CharField(max_length=20, blank=True, default='',null=True)
    GYN_routine=models.BooleanField(default=0)
    GYN_menopausal_syndrome=models.BooleanField(default=0)
    GYN_cervicitis=models.BooleanField(default=0)
    GYN_condyloma=models.BooleanField(default=0)
    GYN_herpes=models.BooleanField(default=0)
    GYN_iud=models.BooleanField(default=0)
    GYN_abnormal_bleeding=models.BooleanField(default=0)
    GYN_cervical_lesion=models.BooleanField(default=0)
    GYN_vaginitis=models.BooleanField(default=0)
    GYN_bleeds_on_contact=models.BooleanField(default=0)
    GYN_infection=models.BooleanField(default=0)
    GYN_discharge=models.BooleanField(default=0)
    GYN_discharge_info= models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_hysterectomy=models.BooleanField(default=0)
    GYN_hysterectomy_description=models.TextField(max_length=300,default='', blank=True, null=True)
    GYN_speciment_type=models.CharField(max_length=40, blank=True, default='',null=True)
    GYN_clinically_suspicious=models.BooleanField(default=0)
    Non_GYN_specimen_source= models.IntegerField(default=0, null=True)
    Non_GYN_clinical_info= models.CharField(max_length=300, blank=True, default='',null=True)
    Non_GYN_gross_description=models.TextField(max_length=400,default='', blank=True, null=True)
    MP_speciment_source= models.CharField(max_length=60, blank=True, default='',null=True)
    SP_clinical_info= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_1= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_1= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_2= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_2= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_3= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_3= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_4= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_4= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_5= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_5= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_6= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_6= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_7= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_7= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_8= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_8= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_9= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_9= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_10= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_10= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_11= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_11= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_specimen_source_12= models.TextField(max_length=600,default='', blank=True, null=True)
    SP_gross_description_12= models.TextField(max_length=600,default='', blank=True, null=True)
    lab_id=models.CharField(max_length=40, blank=True, default='',null=True)
    entry_report=models.FileField(upload_to=get_upload_path_Docs,  null=True, blank=True)

    class Meta:
        verbose_name_plural = 'Entries'

    def updated_price_per_exam(self):
        price=0
        for acc in self.accession_number.all():

            for price in acc.exam_in.clienexamprice_set.all():
                if price.created_for_client.client_id == self.patient.patient_client.client_id and acc.exam_in.exam_id == price.client_exam_id.exam_id:
                    acc.price=price.price
                    acc.save()

        return True

    def price_total(self):
        total=0
        if self.accession_number.all():
            for acc in self.accession_number.all():
                if acc.exam_in.exam_casetype.case_type_id == 1 and acc.GYN_completed == 1:
                    total=total + acc.price

                elif acc.exam_in.exam_casetype.case_type_id == 2 and acc.Non_gyn_completed == 1:
                    total=total + acc.price

                elif acc.exam_in.exam_casetype.case_type_id == 3 and acc.MP_completed == 1:
                    total=total + acc.price

                elif acc.exam_in.exam_casetype.case_type_id == 4 and acc.SP_completed == 1:
                    total=total + acc.price

        return total





class Non_GYN_Specimen_Sources(models.Model):
    id= models.AutoField(primary_key=True)
    name= models.CharField(max_length=120, blank=True, default='',null=True)


##########################################################################################################################################################
#Class to manipulate all Client-Invoices
##########################################################################################################################################################
class ClientInvoices(models.Model):
    id=models.AutoField(primary_key=True)
    created_for = models.ForeignKey(Client, to_field="client_id", default='', unique_for_date="for_month")
    invoice = models.FileField(upload_to=get_upload_path_Inv,  null=False, blank=False)
    for_month=models.IntegerField(default=0, null=False)
    created_date = models.DateTimeField(auto_now_add=True, blank=True, null=True, db_index=True)
    is_paid= models.BooleanField(default=0) #o is pending 1 is paid.

