# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import dashboard.models
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AuthGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=80)),
            ],
            options={
                'db_table': 'auth_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthGroupPermissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('group_id', models.IntegerField()),
                ('permission_id', models.IntegerField()),
            ],
            options={
                'db_table': 'auth_group_permissions',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthPermission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255)),
                ('content_type_id', models.IntegerField()),
                ('codename', models.CharField(max_length=100)),
            ],
            options={
                'db_table': 'auth_permission',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUser',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('password', models.CharField(max_length=128)),
                ('last_login', models.DateTimeField(null=True, blank=True)),
                ('is_superuser', models.IntegerField()),
                ('username', models.CharField(unique=True, max_length=30)),
                ('first_name', models.CharField(max_length=30)),
                ('last_name', models.CharField(max_length=30)),
                ('email', models.CharField(max_length=254)),
                ('is_staff', models.IntegerField()),
                ('is_active', models.IntegerField()),
                ('date_joined', models.DateTimeField()),
            ],
            options={
                'db_table': 'auth_user',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUserGroups',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('user_id', models.IntegerField()),
                ('group_id', models.IntegerField()),
            ],
            options={
                'db_table': 'auth_user_groups',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUserUserPermissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('user_id', models.IntegerField()),
                ('permission_id', models.IntegerField()),
            ],
            options={
                'db_table': 'auth_user_user_permissions',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoAdminLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('action_time', models.DateTimeField()),
                ('object_id', models.TextField(null=True, blank=True)),
                ('object_repr', models.CharField(max_length=200)),
                ('action_flag', models.SmallIntegerField()),
                ('change_message', models.TextField()),
                ('content_type_id', models.IntegerField(null=True, blank=True)),
                ('user_id', models.IntegerField()),
            ],
            options={
                'db_table': 'django_admin_log',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoContentType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('app_label', models.CharField(max_length=100)),
                ('model', models.CharField(max_length=100)),
            ],
            options={
                'db_table': 'django_content_type',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoMigrations',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('app', models.CharField(max_length=255)),
                ('name', models.CharField(default='', max_length=255)),
                ('applied', models.DateTimeField()),
            ],
            options={
                'db_table': 'django_migrations',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoSession',
            fields=[
                ('session_key', models.CharField(max_length=40, serialize=False, primary_key=True)),
                ('session_data', models.TextField()),
                ('expire_date', models.DateTimeField()),
            ],
            options={
                'db_table': 'django_session',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Accession',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('accession_number', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('barcode', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('barcode_img', models.ImageField(null=True, upload_to=dashboard.models.get_upload_path_to_test, blank=True)),
                ('GYN_result_comment', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('GYN_result_caption', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('GYN_result_photo', models.ImageField(null=True, upload_to=dashboard.models.get_upload_path_to_test2, blank=True)),
                ('Non_GYN_result_speciment_received', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('Non_GYN_result_clinical_data', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('Non_GYN_result_gross_description', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('Non_GYN_result_diagnosis', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('Non_GYN_result_comment', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('Non_GYN_result_photo', models.ImageField(null=True, upload_to=dashboard.models.get_upload_path_to_test2, blank=True)),
                ('Non_GYN_result_caption', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('MP_result_comment', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('MP_result_photo', models.ImageField(null=True, upload_to=dashboard.models.get_upload_path_to_test2, blank=True)),
                ('MP_result_caption', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('SP_completed', models.BooleanField(default=0)),
                ('MP_completed', models.BooleanField(default=0)),
                ('Non_gyn_completed', models.BooleanField(default=0)),
                ('GYN_completed', models.BooleanField(default=0)),
                ('completed_date', models.DateField(db_index=True, null=True, blank=True)),
                ('SP_result_part_1', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_2', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_3', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_4', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_5', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_6', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_7', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_8', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_9', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_10', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_11', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_part_12', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('SP_result_comment', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('SP_result_photo', models.ImageField(null=True, upload_to=dashboard.models.get_upload_path_to_test2, blank=True)),
                ('SP_result_caption', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('finalized_date', models.DateTimeField(null=True, blank=True)),
                ('price', models.DecimalField(default=0, max_digits=10, decimal_places=2)),
                ('pathology_queve', models.BooleanField(default=0)),
                ('pathology_aproved', models.BooleanField(default=0)),
                ('pathology_comment', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('quality_control', models.BooleanField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='CaseType',
            fields=[
                ('case_type_id', models.AutoField(serialize=False, primary_key=True)),
                ('case_type_name', models.CharField(default='', max_length=40, null=True, blank=True)),
            ],
            options={
                'verbose_name_plural': 'CaseTypes',
            },
        ),
        migrations.CreateModel(
            name='ClienExamPrice',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('price', models.DecimalField(default=0, max_digits=10, decimal_places=2)),
            ],
            options={
                'verbose_name_plural': 'ClienExamPrices',
            },
        ),
        migrations.CreateModel(
            name='Client',
            fields=[
                ('client_id', models.AutoField(serialize=False, primary_key=True)),
                ('client_code', models.CharField(default='', max_length=20, unique=True, null=True)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('first_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('last_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('business_UPIN_number', models.CharField(default='', max_length=30, null=True, blank=True)),
                ('business_legal_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('business_phone', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('contact_phone', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('business_ext', models.CharField(default='', max_length=10, null=True, blank=True)),
                ('business_fax', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('business_email', models.CharField(default='', max_length=254, null=True)),
                ('business_address', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('business_address2', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('business_city', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('business_state', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('business_zipcode', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('representative_SSN_number', models.CharField(default='', max_length=10, null=True, blank=True)),
                ('is_aproved', models.BooleanField(default=0)),
                ('notification', models.BooleanField(default=0)),
                ('e_fax', models.BooleanField(default=0)),
                ('website', models.BooleanField(default=0)),
                ('printed', models.BooleanField(default=0)),
                ('interface', models.BooleanField(default=0)),
                ('lab_id', models.BooleanField(default=1)),
                ('attending_physician_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('client_user', models.OneToOneField(related_name='client', null=True, on_delete=django.db.models.deletion.SET_NULL, blank=True, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Clients',
            },
        ),
        migrations.CreateModel(
            name='ClientInvoices',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('invoice', models.FileField(upload_to=dashboard.models.get_upload_path_Inv)),
                ('for_month', models.IntegerField(default=0)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('is_paid', models.BooleanField(default=0)),
                ('created_for', models.ForeignKey(default='', to='dashboard.Client', unique_for_date='for_month')),
            ],
        ),
        migrations.CreateModel(
            name='Entry',
            fields=[
                ('entry_id', models.AutoField(serialize=False, primary_key=True)),
                ('collection_date', models.DateField(db_index=True, null=True, blank=True)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('physician_name', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('step', models.IntegerField(default=0, null=True)),
                ('notes', models.TextField(default='', null=True, blank=True)),
                ('initial_info', models.IntegerField(default=0, null=True)),
                ('GYN_Cervix', models.BooleanField(default=0)),
                ('GYN_Vaginal', models.BooleanField(default=0)),
                ('GYN_Endocervix', models.BooleanField(default=0)),
                ('GYN_None', models.BooleanField(default=0)),
                ('GYN_mestrual', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_last_menstrual_period', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_previous_biopsy', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_pap_smear', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_abnormal_report', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('GYN_routine', models.BooleanField(default=0)),
                ('GYN_menopausal_syndrome', models.BooleanField(default=0)),
                ('GYN_cervicitis', models.BooleanField(default=0)),
                ('GYN_condyloma', models.BooleanField(default=0)),
                ('GYN_herpes', models.BooleanField(default=0)),
                ('GYN_iud', models.BooleanField(default=0)),
                ('GYN_abnormal_bleeding', models.BooleanField(default=0)),
                ('GYN_cervical_lesion', models.BooleanField(default=0)),
                ('GYN_vaginitis', models.BooleanField(default=0)),
                ('GYN_bleeds_on_contact', models.BooleanField(default=0)),
                ('GYN_infection', models.BooleanField(default=0)),
                ('GYN_discharge', models.BooleanField(default=0)),
                ('GYN_discharge_info', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_hysterectomy', models.BooleanField(default=0)),
                ('GYN_hysterectomy_description', models.TextField(default='', max_length=300, null=True, blank=True)),
                ('GYN_speciment_type', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('GYN_clinically_suspicious', models.BooleanField(default=0)),
                ('Non_GYN_specimen_source', models.IntegerField(default=0, null=True)),
                ('Non_GYN_clinical_info', models.CharField(default='', max_length=300, null=True, blank=True)),
                ('Non_GYN_gross_description', models.TextField(default='', max_length=400, null=True, blank=True)),
                ('MP_speciment_source', models.CharField(default='', max_length=60, null=True, blank=True)),
                ('SP_clinical_info', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_1', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_1', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_2', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_2', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_3', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_3', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_4', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_4', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_5', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_5', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_6', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_6', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_7', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_7', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_8', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_8', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_9', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_9', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_10', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_10', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_11', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_11', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_specimen_source_12', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('SP_gross_description_12', models.TextField(default='', max_length=600, null=True, blank=True)),
                ('lab_id', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('entry_report', models.FileField(null=True, upload_to=dashboard.models.get_upload_path_Docs, blank=True)),
                ('accession_number', models.ManyToManyField(default='', related_name='access', to='dashboard.Accession', blank=True)),
            ],
            options={
                'verbose_name_plural': 'Entries',
            },
        ),
        migrations.CreateModel(
            name='Exam',
            fields=[
                ('exam_id', models.AutoField(serialize=False, primary_key=True)),
                ('exam_name', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('test_code', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('cpt_name', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('exam_description', models.CharField(default='', max_length=400, null=True, blank=True)),
                ('exam_default_price', models.DecimalField(default=0, max_digits=10, decimal_places=2)),
                ('how_many_cut', models.IntegerField(default=0, null=True)),
                ('lab_id', models.BooleanField(default=1)),
                ('exam_casetype', models.ForeignKey(to='dashboard.CaseType')),
            ],
            options={
                'verbose_name_plural': 'Exams',
            },
        ),
        migrations.CreateModel(
            name='Lab',
            fields=[
                ('lab_id', models.AutoField(serialize=False, primary_key=True)),
                ('lab_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('lab_clia_id', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('lab_address', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('lab_address2', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('lab_city', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('lab_state', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('lab_zipcode', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('lab_phone', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('lab_fax', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('lab_email', models.CharField(max_length=254)),
                ('lab_website', models.CharField(max_length=254)),
            ],
            options={
                'verbose_name_plural': 'Labs',
            },
        ),
        migrations.CreateModel(
            name='Non_GYN_Specimen_Sources',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('name', models.CharField(default='', max_length=120, null=True, blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('patient_id', models.AutoField(serialize=False, primary_key=True)),
                ('ext_id', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('dob', models.DateField(default=None, null=True, blank=True)),
                ('age', models.IntegerField(null=True, blank=True)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('first_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('last_name', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('phone', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('address', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('address2', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('city', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('state', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('zipcode', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('SSN_number', models.CharField(default='', max_length=10, null=True, blank=True)),
                ('gender', models.CharField(default='', max_length=1, null=True, choices=[('M', 'Male'), ('F', 'Female')])),
                ('lab_id', models.BooleanField(default=1)),
                ('notification', models.BooleanField(default=0)),
                ('ethnicity', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('insurance_type', models.BooleanField(default=0)),
                ('insurance_name', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_dob', models.DateField(default=None, null=True, blank=True)),
                ('insurance_suscriber_number', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_group', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_ICD10', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_UPIN', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_responsible_party', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('insurance_relationship', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('patient_client', models.ForeignKey(default='', blank=True, to='dashboard.Client', null=True)),
                ('patient_user', models.OneToOneField(related_name='patient_user', null=True, on_delete=django.db.models.deletion.SET_NULL, default='', blank=True, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Patients',
            },
        ),
        migrations.CreateModel(
            name='Result_code',
            fields=[
                ('code_id', models.AutoField(serialize=False, primary_key=True)),
                ('code_name', models.CharField(default='', max_length=20, unique=True, null=True, blank=True)),
                ('code_description', models.CharField(default='', max_length=120, null=True, blank=True)),
                ('code_result_type', models.BooleanField(default=0)),
                ('lab_id', models.BooleanField(default=1)),
                ('code_casetype_result', models.ForeignKey(to='dashboard.CaseType')),
            ],
            options={
                'verbose_name_plural': 'Result_codes',
            },
        ),
        migrations.CreateModel(
            name='ResultCategory',
            fields=[
                ('cat_id', models.AutoField(serialize=False, primary_key=True)),
                ('cat_name', models.CharField(default='', max_length=40, null=True, blank=True)),
                ('short_name', models.CharField(default='', max_length=40, null=True, blank=True)),
            ],
            options={
                'verbose_name_plural': 'ResultCategories',
            },
        ),
        migrations.CreateModel(
            name='ResultSubCategory',
            fields=[
                ('subcat_id', models.AutoField(serialize=False, primary_key=True)),
                ('subcat_name', models.CharField(default='', max_length=40, null=True, blank=True)),
            ],
            options={
                'verbose_name_plural': 'ResultSubCategories',
            },
        ),
        migrations.CreateModel(
            name='state',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('code', models.CharField(max_length=2)),
                ('name', models.CharField(max_length=64)),
            ],
            options={
                'verbose_name_plural': 'States',
            },
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.AutoField(serialize=False, primary_key=True)),
                ('phone', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('created_date', models.DateTimeField(db_index=True, auto_now_add=True, null=True)),
                ('address', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('address2', models.CharField(default='', max_length=150, null=True, blank=True)),
                ('city', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('state', models.CharField(default='', max_length=50, null=True, blank=True)),
                ('zipcode', models.CharField(default='', max_length=20, null=True, blank=True)),
                ('lab_id', models.BooleanField(default=1)),
                ('user', models.OneToOneField(related_name='user', null=True, on_delete=django.db.models.deletion.SET_NULL, blank=True, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'UserProfiles',
            },
        ),
        migrations.AddField(
            model_name='result_code',
            name='code_result_area',
            field=models.ForeignKey(to='dashboard.ResultCategory'),
        ),
        migrations.AddField(
            model_name='result_code',
            name='code_result_subcat',
            field=models.ForeignKey(default='', to='dashboard.ResultSubCategory'),
        ),
        migrations.AddField(
            model_name='entry',
            name='patient',
            field=models.ForeignKey(to='dashboard.Patient', unique_for_date='collection_date'),
        ),
        migrations.AddField(
            model_name='entry',
            name='test_in_entry',
            field=models.ManyToManyField(default='', related_name='entry', to='dashboard.Exam', blank=True),
        ),
        migrations.AddField(
            model_name='clienexamprice',
            name='client_exam_id',
            field=models.ForeignKey(default='', to='dashboard.Exam'),
        ),
        migrations.AddField(
            model_name='clienexamprice',
            name='created_for_client',
            field=models.ForeignKey(default='', to='dashboard.Client'),
        ),
        migrations.AddField(
            model_name='accession',
            name='exam_in',
            field=models.ForeignKey(default='', to='dashboard.Exam'),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_additional',
            field=models.ManyToManyField(default='', related_name='additional', to='dashboard.Result_code', blank=True),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_hormonal',
            field=models.ManyToManyField(default='', related_name='hormonal', to='dashboard.Result_code', blank=True),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_interpretation',
            field=models.ManyToManyField(default='', related_name='interpretation', to='dashboard.Result_code', blank=True),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_molecular_CHlamydia_trachomatis',
            field=models.ManyToManyField(default='', related_name='chlamydia', to='dashboard.Result_code', blank=True),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_molecular_Neiseria_gonorroeae',
            field=models.ManyToManyField(default='', related_name='gonorroea', to='dashboard.Result_code', blank=True),
        ),
        migrations.AddField(
            model_name='accession',
            name='result_in_speciment',
            field=models.ManyToManyField(default='', related_name='speciment', to='dashboard.Result_code', blank=True),
        ),
    ]
