from django.conf.urls import patterns, include, url
from django.contrib import admin
import settings

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'roocdx.views.home', name='home'),
    # url(r'^blog/', include('blog.urls')),

    url(r'^$','home.views.home', name='home'),
    url(r'^home/$','home.views.home', name='home'),

    url(r'^dashboard/$','dashboard.views.dashboard', name='dashboard'),
    url(r'^dashboard/login_user/$','dashboard.views.login_user', name='login_user'),
    url(r'^dashboard/logout_user/$','dashboard.views.logout_user', name='logout_user'),
    url(r'^dashboard/signup/$','dashboard.views.signup', name='signup'),
    url(r'^dashboard/forgot_passwd/$','dashboard.views.forgot_passwd', name='forgot_passwd'),

    url(r'^dashboard/queve/$','dashboard.views.queve', name='queve'),
    url(r'^dashboard/queve/(?P<st_id>\d+)/$','dashboard.views.queve', name='queve'),
    url(r'^dashboard/new_entry/$','dashboard.views.new_entry', name='new_entry'),
    url(r'^dashboard/pathology_queve/$','dashboard.views.pathology_queve', name='pathology_queve'),
    url(r'^dashboard/quality_queve/$','dashboard.views.quality_queve', name='quality_queve'),
    url(r'^dashboard/all_requisitions/$','dashboard.views.all_requisitions', name='all_requisitions'),

    url(r'^dashboard/wizard/(?P<step_id>\d+)/$','dashboard.views.wizard', name='wizard'),
    url(r'^dashboard/wizard/$','dashboard.views.wizard', name='wizard'),


    url(r'^dashboard/users/$','dashboard.views.users', name='users'),
    url(r'^dashboard/users/(?P<user_id>\d+)/$','dashboard.views.view_user', name='view_user'),
    url(r'^dashboard/add_user/$','dashboard.views.add_user', name='add_user'),
    url(r'^dashboard/all_users/$','dashboard.views.all_users', name='all_users'),


    url(r'^dashboard/add_client/$','dashboard.views.add_client', name='add_client'),
    url(r'^dashboard/pending_client/$','dashboard.views.pending_client', name='pending_client'),
    url(r'^dashboard/all_client/$','dashboard.views.all_client', name='all_client'),
    url(r'^dashboard/edit_client/(?P<client_id>\d+)/$','dashboard.views.edit_client', name='edit_client'),
    url(r'^dashboard/update_client_price/(?P<client_id>\d+)/$','dashboard.views.update_client_price', name='update_client_price'),

    url(r'^dashboard/search_for_client/$','dashboard.views.search_for_client', name='search_for_client'),
    url(r'^dashboard/search_for_username/$','dashboard.views.search_for_username', name='search_for_username'),

    url(r'^dashboard/enter_result/(?P<entry_id>\d+)/$','dashboard.views.enter_result', name='enter_result'),
    url(r'^dashboard/view_detail/(?P<entry_id>\d+)/$','dashboard.views.view_detail', name='view_detail'),
    url(r'^dashboard/view_pdf/(?P<entry_id>\d+)/$','dashboard.views.view_pdf', name='view_pdf'),
    url(r'^dashboard/toPDF/(?P<entry_id>\d+)/(?P<accession_id>\d+)/$','dashboard.views.toPDF', name='toPDF'),
    url(r'^dashboard/export_pdf/$','dashboard.views.export_pdf', name='export_pdf'),

    url(r'^dashboard/add_patient/$','dashboard.views.add_patient', name='add_patient'),
    url(r'^dashboard/all_patient/$','dashboard.views.all_patient', name='all_patient'),
    url(r'^dashboard/edit_patient/(?P<patient_id>\d+)/$','dashboard.views.edit_patient', name='edit_patient'),
    url(r'^dashboard/search/$','dashboard.views.search', name='search'),


    url(r'^dashboard/add_exam/$','dashboard.views.add_exam', name='add_exam'),
    url(r'^dashboard/add_exam/(?P<exam_id>\d+)/$','dashboard.views.add_exam', name='add_exam'),
    url(r'^dashboard/del_exam/$','dashboard.views.del_exam', name='del_exam'),

    url(r'^dashboard/add_result/$','dashboard.views.add_result', name='add_result'),
    url(r'^dashboard/add_result/(?P<code_id>\d+)/$','dashboard.views.add_result', name='add_result'),
    url(r'^dashboard/list_result/$','dashboard.views.list_result', name='list_result'),

   url(r'^dashboard/billing/$','dashboard.views.billing', name='billing'),
   url(r'^dashboard/billing/(?P<month>\d+)/$','dashboard.views.billing', name='billing'),
   url(r'^dashboard/invoice/(?P<client_id>\d+)/$','dashboard.views.invoice', name='invoice'),
   url(r'^dashboard/invoice/(?P<client_id>\d+)/(?P<month>\d+)/$','dashboard.views.invoice', name='invoice'),
   url(r'^dashboard/invoicetoPDF/(?P<client_id>\d+)/(?P<month>\d+)/$','dashboard.views.invoicetoPDF', name='invoicetoPDF'),


   url(r'^dashboard/invoice/(?P<client_id>\d+)/(?P<month>\d+)/(?P<year>\d+)/$','dashboard.views.invoice', name='invoice'),






    url(r'^dashboard/report/$','dashboard.views.report', name='report'),
    #url(r'^dashboard/blank/$','dashboard.views.blank', name='blank'),
    #url(r'^dashboard/blank/$','dashboard.views.blank', name='blank'),
    #url(r'^dashboard/blank/$','dashboard.views.blank', name='blank'),
    url(r'^dashboard/blank/$','dashboard.views.blank', name='blank'),


    #url(r'^home/login_user/$','home.views.login_user', name='login_user'),
    #url(r'^home/logout_user/$','home.views.logout_user', name='logout_user'),
   # url(r'^home/signup/$','home.views.signup', name='signup'),
    url(r'^admin/', include(admin.site.urls)),
)



if settings.DEBUG:
    from django.views.static import serve
    _media_url = settings.MEDIA_URL
    if _media_url.startswith('/'):
        _media_url = _media_url[1:]
        urlpatterns += patterns('',
                                (r'^%s(?P<path>.*)$' % _media_url,
                                serve,
                                {'document_root': settings.MEDIA_ROOT}))
    del(_media_url, serve)